package com.liquidnet.service.account.funding.dto.base;

import com.liquidnet.service.account.common.ErrorConstants;
import io.swagger.annotations.ApiModelProperty;

/**
 * FundingCallResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/20
 */
public class FundingCallResult<T> implements java.io.Serializable {
    private static final long serialVersionUID = 3689823931373110723L;
    @ApiModelProperty(position = 1, value = "状态码")
    protected String code;
    @ApiModelProperty(position = 2, value = "状态描述")
    protected String message;
    @ApiModelProperty(position = 3, value = "返回数据")
    protected T data;

    public FundingCallResult() {
        this.code = ErrorConstants.SUCCESS_CODE;
        this.message = ErrorConstants.SUCCESS_DETAILS;
    }

    public FundingCallResult(T data) {
        this.code = ErrorConstants.SUCCESS_CODE;
        this.message = ErrorConstants.SUCCESS_DETAILS;
        this.data = data;
    }

    public FundingCallResult(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isProcessing() {
        return this.code.equals(ErrorConstants.PROCESSING_CODE);
    }

    public boolean isSuccess() {
        return this.code.equals(ErrorConstants.SUCCESS_CODE);
    }

    public boolean isFailed() {
        return !this.code.equals(ErrorConstants.SUCCESS_CODE) && !this.code.equals(ErrorConstants.PROCESSING_CODE);
    }
}
