package com.liquidnet.service.account.wallet.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.wallet.dto.WalletCalTransBalanceParam;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.dto.base.WalletContextParam;
import com.liquidnet.service.account.wallet.service.processor.WalletTransCalBalanceProcessor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * WalletCostingController.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/2
 */
@Api(tags = "Wallet transaction costing")
@RestController
@RequestMapping("wl/costing")
public class WalletCostingController {
    private static final Logger log = LoggerFactory.getLogger(WalletCostingController.class);
    @Autowired
    private WalletTransCalBalanceProcessor transCalBalanceProcessor;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Calculate transaction balance")
    @PostMapping("transBalance")
    public WalletCallResult<?> calTransBalance(@RequestBody WalletCalTransBalanceParam parameter) {
        try {
            log.info("Calculate transaction balance begin");
            WalletContextParam contextParam = WalletContextParam.getNew();
            BeanUtils.copyProperties(parameter, contextParam);
            contextParam.setTradeType(parameter.getClass().getSimpleName());
            WalletCallResult<?> result = transCalBalanceProcessor.service(contextParam);
            log.info("Calculate transaction balance end.result:[{}]", JsonUtils.toJson(result));
        } catch (Exception e) {
            log.error("Call handle exception:[Calculate transaction balance]", e);
            return new WalletCallResult<>(ErrorConstants.WALLET_COST_ERROR_CODE, "Push transaction details failed");
        }
        return new WalletCallResult<>();
    }
}
