package com.liquidnet.service.account.wallet.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.wallet.dto.WalletDashboardParam;
import com.liquidnet.service.account.wallet.dto.WalletDashboardResult;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.dto.base.WalletContextParam;
import com.liquidnet.service.account.wallet.service.processor.WalletDashboardProcessor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * WalletDashboardController.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/9
 */
@Api(tags = "Wallet dashboard")
@RestController
@RequestMapping("wl/dashboard")
public class WalletDashboardController {
    private static final Logger log = LoggerFactory.getLogger(WalletDashboardController.class);
    @Autowired
    private WalletDashboardProcessor dashboardProcessor;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Wallet dashboard show")
    @PostMapping("show")
    public WalletDashboardResult show(@RequestBody WalletDashboardParam parameter) {
        if (null == parameter) {
            return new WalletDashboardResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, ErrorConstants.PARAMS_VALUE_ERROR_DESC);
        }
        log.info("Call {}:[{}]", parameter.getClass().getSimpleName(), JsonUtils.toJson(parameter));
        WalletContextParam contextParam = WalletContextParam.getNew();
        BeanUtils.copyProperties(parameter, contextParam);
        contextParam.setTradeType(parameter.getClass().getSimpleName());
        WalletDashboardResult result = null;
        try {
            WalletCallResult<?> rst = dashboardProcessor.service(contextParam);
            result = rst instanceof WalletDashboardResult ? (WalletDashboardResult) rst
                    : new WalletDashboardResult(rst.getCode(), rst.getMessage());
        } catch (Exception e) {
            log.error("Call {} handle exception:[{}]", parameter.getClass().getSimpleName(), JsonUtils.toJson(parameter), e);
            result = new WalletDashboardResult(ErrorConstants.WALLET_DASHBOARD_ERROR_CODE, ErrorConstants.WALLET_DASHBOARD_ERROR_DESC);
        }
        result.setData(parameter);
        log.info("Call {}:[{}]", result.getClass().getSimpleName(), JsonUtils.toJson(result));
        return result;
    }
}
