package com.liquidnet.service.account.wallet.service.impl;

import com.liquidnet.service.account.wallet.entity.FinBizTrade;
import com.liquidnet.service.account.wallet.entity.FinBizTradeExample;
import com.liquidnet.service.account.wallet.mapper.FinBizTradeMapper;
import com.liquidnet.service.account.wallet.service.FinBizTradeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class FinBizTradeServiceImpl implements FinBizTradeService {
    private static final Logger log = LoggerFactory.getLogger(FinBizTradeServiceImpl.class);
    @Autowired
    private FinBizTradeMapper bizTradeMapper;

    @Override
    public int addBizTrade(FinBizTrade bizTrade) {
        return bizTradeMapper.insertSelective(bizTrade);
    }

    @Override
    public FinBizTrade query(String channelId, String bizType, String reqNo) {
        FinBizTradeExample example = new FinBizTradeExample();
        example.createCriteria().andChannelIdEqualTo(channelId).andBizTypeEqualTo(bizType);
        List<FinBizTrade> list = bizTradeMapper.selectByExample(example);
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    @Override
    public int updateTradeStatus(String tradeNo, int tradeStatus) {
        FinBizTrade updateInfo = FinBizTrade.getNew();
        updateInfo.setTradeNo(tradeNo);
        updateInfo.setTradeStatus(tradeStatus);
        updateInfo.setUpdateTime(LocalDateTime.now());

        return bizTradeMapper.updateByPrimaryKeySelective(updateInfo);
    }
}
