package com.liquidnet.service.account.wallet.service.impl;

import com.github.pagehelper.PageHelper;
import com.liquidnet.service.account.wallet.entity.FinBizTransExtra;
import com.liquidnet.service.account.wallet.entity.FinBizTransExtraExample;
import com.liquidnet.service.account.wallet.mapper.FinBizTransExtraMapper;
import com.liquidnet.service.account.wallet.service.FinBizTransExtraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * FinBizTransExtraServiceImpl.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/2
 */
@Service
public class FinBizTransExtraServiceImpl implements FinBizTransExtraService {
    private static final Logger log = LoggerFactory.getLogger(FinBizTransExtraServiceImpl.class);
    @Autowired
    private FinBizTransExtraMapper transExtraMapper;

    @Override
    public List<FinBizTransExtra> queryLastTransBalance(String walletNo) {
        FinBizTransExtraExample example = new FinBizTransExtraExample();
        example.createCriteria().andWalletNoEqualTo(walletNo);
        example.setOrderByClause("FBTE0 DESC");
        PageHelper.startPage(1, 1);
        return transExtraMapper.selectByExample(example);
    }

    @Override
    public int addByBatch(List<FinBizTransExtra> records) {
        return transExtraMapper.insertByBatch(records);
    }
}
