package com.liquidnet.service.bank.currencycloud.constant;

public class BankCcFundingConstants {

    public enum StatusEnum {
        PENDING("pending"),
        DELETED("deleted"),
        COMPLETED("completed"),
        ;

        private String code;

        public static StatusEnum getEnumByCode(String code) {
            StatusEnum[] array = values();
            for (StatusEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        StatusEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

    }

}
