package com.liquidnet.service.bank.currencycloud.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.List;

/**
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "cc push notify payment")
public class BankCcPushNotifyPayment {
    @JsonProperty(value = "id")
    private String id;

    @JsonProperty(value = "amount")
    private String amount;

    @JsonProperty(value = "failure_returned_amount")
    private String failureReturnedAmount;

    @JsonProperty(value = "beneficiary_id")
    private String beneficiaryId;

    @JsonProperty(value = "conversion_id")
    private String conversionId;

    @JsonProperty(value = "currency")
    private String currency;

    @JsonProperty(value = "reference")
    private String reference;

    @JsonProperty(value = "reason")
    private String reason;

    @JsonProperty(value = "status")
    private String status;

    @JsonProperty(value = "payment_type")
    private String paymentType;

    @JsonProperty(value = "payment_date")
    private String paymentDate;

    @JsonProperty(value = "transferred_at")
    private String transferredAt;

    @JsonProperty(value = "authorisation_steps_required")
    private String authorisationStepsRequired;

    @JsonProperty(value = "creator_contact_id")
    private String creatorContactId;

    @JsonProperty(value = "last_updater_contact_id")
    private String lastUpdaterContactId;

    @JsonProperty(value = "short_reference")
    private String shortReference;

    @JsonProperty(value = "failure_reason")
    private String failureReason;

    @JsonProperty(value = "payment_group_id")
    private String paymentGroupId;

    @JsonProperty(value = "unique_request_id")
    private String uniqueRequestId;

}
