package com.liquidnet.service.bank.config;

import com.liquidnet.common.swagger.config.Swagger2Config;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

import java.util.Arrays;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: Swagger2Config
 * @Package com.liquidnet.stellar.configuration
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/10 13:55
 */
@Configuration
class BankSwagger2Config extends Swagger2Config {

    @Bean
    public Docket api_cc() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
                .groupName(BankSwaggerApiVersionConstant.API_CC)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(BankSwaggerApiVersionConstant.API_CC);
                })
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket api_1_0() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
//                .globalOperationParameters(headParamDefault())
                .groupName(BankSwaggerApiVersionConstant.API_1_0)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(BankSwaggerApiVersionConstant.API_1_0);
                })
                .paths(PathSelectors.any())
                .build();
    }

//    /**
//     * 设置默认请求头部 参数
//     * sid
//     */
//    private List<Parameter> headParamDefault() {
//        ParameterBuilder ticketPar = new ParameterBuilder();
//        List<Parameter> pars = new ArrayList<>();
//        ticketPar.name("sid").description("user sid")
//                .modelRef(new ModelRef("string")).parameterType("header")
//                .required(true).build(); //header中的ticket参数非必填，传空也可以
//        pars.add(ticketPar.build());    //根据每个方法名也知道当前方法在设置什么参数
//        return pars;
//    }

}
