package com.liquidnet.service.bank.currencycloud.controller;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcFundingAccountDto;
import com.liquidnet.service.bank.currencycloud.service.IBankCcFundingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Api(tags = "funding")
@Slf4j
@RestController
@RequestMapping("/bank-cc-funding")
public class BankCcFundingController {

    @Autowired
    private IBankCcFundingService bankCcFundingService;

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "get funding account")
    @GetMapping(value = "/get_funding_account")
    public ResponseDto<List<BankCcFundingAccountDto>> getFundingAccount(@RequestParam String accountId, @RequestParam String currency) {
        BankResultDto<List<BankCcFundingAccountDto>> resultDto = bankCcFundingService.getFundingAccount(accountId, currency);
        return BankResultDto.getResponseDto(resultDto);
    }

}
