package com.liquidnet.service.bank.feign;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import com.liquidnet.service.bank.currencycloud.entity.BankCcTransaction;
import com.liquidnet.service.feign.adam.api.account.FeignAdamTransactionClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value = "bankFeignAdamTransactionService")
public class BankFeignAdamTransactionServiceImpl implements IBankFeignAdamTransactionService {

    @Autowired
    FeignAdamTransactionClient feignAdamTransactionClient;

    @Override
    public ResponseDto pushNotifyBankCcFunding(BankCcTransaction funding) {
        return feignAdamTransactionClient.pushNotifyBankCcFunding(funding);
    }

    @Override
    public ResponseDto pushNotifyBankCcConversion(BankCcConversionDto conversionDto) {
        return feignAdamTransactionClient.pushNotifyBankCcConversion(conversionDto);
    }

    @Override
    public ResponseDto pushNotifyBankCcPayment(BankCcPayment payment) {
        return feignAdamTransactionClient.pushNotifyBankCcPayment(payment);
    }

}
