package com.liquidnet.service.kylin.controller.admin;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.service.impl.admin.KylinRefundPerformancesAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;

/**
 * <p>
 * 后台按演出批量退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 11:07 上午
 */

@Api(tags = "后端-批量退款")
@RestController
@RequestMapping("admin/refundBatch")

public class KylinRefundBatchAdminController {

    @Autowired
    private KylinRefundPerformancesAdminServiceImpl kylinRefundPerformancesAdminServiceImpl;

    @PostMapping("apply")
    @ApiOperation("申请演出退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "targetId", value = "ID targetType=1为演出id", required = true),
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "targetType", value = "类型 1演出", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "reason", value = "申请备注", required = true),
    })
    public ResponseDto<Object> refundBatchApply(
            @RequestBody String targetId,
            @RequestBody Integer targetType,
            @RequestBody String reason
    ) {
        Integer authId = 1;
        String authName = "jxl";

        String token = "22adsd34tt";
        HashMap<String, Object> otherParam = new HashMap();
        otherParam.put("token", token);
        otherParam.put("reason", reason);

        try {
            if (1 == targetType) {
                Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchApply(targetId, targetType, authId, authName, otherParam);
                if (res) {
                    return ResponseDto.success();
                } else {
                    return ResponseDto.failure("申请演出退款失败");
                }
            } else {
                return ResponseDto.failure("参数错误");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    @PostMapping("reapply")
    @ApiOperation("再次提交审核")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundBatchId", value = "refundBatchId 批量id", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "remark", value = "再次提交备注", required = true),
    })
    public ResponseDto<Object> refundBatchApply(
            @RequestBody String refundBatchId,
            @RequestBody String remark
    ) throws Exception {
        String token = "22adsd34tt";
        HashMap<String, Object> otherParam = new HashMap();
        otherParam.put("token", token);
        otherParam.put("type", "reapply");
        Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchReapply(refundBatchId, remark, otherParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("提交审核失败");
        }
    }

    @PostMapping("cancel")
    @ApiOperation("取消退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundBatchId", value = "refundBatchId 批量id", required = true)
    })
    public ResponseDto<Object> refundBatchCancel(
            @RequestBody String refundBatchId
    ) throws Exception {
        String token = "22adsd34tt";
        HashMap<String, Object> otherParam = new HashMap();
        otherParam.put("token", token);
        otherParam.put("type", "cancel");
        Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchCancel(refundBatchId, otherParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("取消退款失败");
        }
    }

    @PostMapping("review")
    @ApiOperation("审核/驳回")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundBatchId", value = "refundBatchId 批量id", required = true),
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "status", value = "状态 3运营驳回审核 4运营通过审核", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "reject", value = "备注", required = true)
    })
    public ResponseDto<Object> refundBatchReview(
            @RequestBody String refundBatchId,
            @RequestBody Integer status,
            @RequestBody String reject
    ) throws Exception {
        String token = "22adsd34tt";
        HashMap<String, Object> otherParam = new HashMap();
        otherParam.put("token", token);
        otherParam.put("type", "review");
        otherParam.put("status", status);
        otherParam.put("reject", reject);

        Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchReview(refundBatchId, otherParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("审核失败");
        }
    }

    @PostMapping("execute")
    @ApiOperation("执行退款/拒绝退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundBatchId", value = "refundBatchId 批量id", required = true),
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "status", value = "状态 5财务驳回审核 6财务通过审核", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "refuse", value = "备注", required = true)
    })
    public ResponseDto<Object> refundBatchExecute(
            @RequestBody String refundBatchId,
            @RequestBody Integer status,
            @RequestBody String refuse
    ) throws Exception {
        String token = "22adsd34tt";
        HashMap<String, Object> otherParam = new HashMap();
        otherParam.put("token", token);
        otherParam.put("type", "execute");
        otherParam.put("status", status);
        otherParam.put("refuse", refuse);

        Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchExecute(refundBatchId, otherParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("审核失败");
        }
    }

}
