package com.liquidnet.service.reconciliation.controller;

import com.liquidnet.service.reconciliation.service.adam.IAdamTransactionService;
import com.liquidnet.service.reconciliation.service.core.ILrTradePaymentQueryService;
import com.liquidnet.service.reconciliation.service.core.ILrTradeReconciliationService;
import com.liquidnet.service.reconciliation.service.wallet.IFinWlN07Service;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: LrAccountCheckTestController
 * @Package com.liquidnet.service.reconciliation.controller
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/22 15:58
 */
@Api(tags = "recon-test")
@RestController
@RequestMapping("/test")
public class LrAccountCheckTestController {
    private static final Logger logger = LoggerFactory.getLogger(LrAccountCheckTestController.class);

    @Autowired
    private IAdamTransactionService adamTransactionService;

    @Autowired
    private IFinWlN07Service finWlN07Service;

    //获取acs数据
    @ApiOperation(value = "getAcsList")
    @ResponseBody
    @RequestMapping(value = "/getAcsList", method = RequestMethod.POST)
    public ResponseEntity<?> getAcsList() {
        logger.info("getAcsList ===>>>");
        return ResponseEntity.ok(finWlN07Service.list());
    }

    //获取adam数据
    @ApiOperation(value = "getAdamList")
    @ResponseBody
    @GetMapping(value = "/getAdamList")
    public ResponseEntity<?> getAdamList(String str) {
        logger.info("getAdamList ===>>>");
        return ResponseEntity.ok(adamTransactionService.list());
    }

    //获取adam数据
    @ApiOperation(value = "getFundDataList")
    @ResponseBody
    @GetMapping(value = "/getFundDataList")
    public ResponseEntity<?> getFundDataList(String bankChannel) {
        logger.info("getFundDataList ===>>>");
        return ResponseEntity.ok(adamTransactionService.list());
    }
}
