package com.liquidnet.service.reconciliation.strategy.accounting.impl;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.liquidnet.service.reconciliation.biz.ReconciliationDataGetBiz;
import com.liquidnet.service.reconciliation.constant.ReconConstants;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.dto.FundFlowCommonInfo;
import com.liquidnet.service.reconciliation.dto.TdFundflowUploadVO;
import com.liquidnet.service.reconciliation.dto.TransFundQueryFilter;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatch;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatchSub;
import com.liquidnet.service.reconciliation.service.ILrAccountCheckMistakeScratchPoolService;
import com.liquidnet.service.reconciliation.service.core.ILrAccountCheckTransactionService;
import com.liquidnet.service.reconciliation.strategy.accounting.annotation.StrategyComparingAccountHandler;
import com.liquidnet.service.reconciliation.strategy.transtype.ITransTypeStrategy;
import com.liquidnet.service.reconciliation.strategy.transtype.TransTypeStrategyContext;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: ComparingAccountLiquidnetWallet
 * @Package com.liquidnet.service.reconciliation.accounting
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/23 16:05
 */
@Component
@StrategyComparingAccountHandler(BankChannelEnum.LIQUIDNET_WALLET)
public class ComparingAccountStrategyLiquidnetWalletImpl extends AbstractComparingAccountStrategy {
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @Override
    public void setBankChannel(BankChannelEnum bankChannel) {
        this.bankChannel = BankChannelEnum.LIQUIDNET_WALLET;
    }

    @Override
    public void setInfoBankChannel(BankChannelEnum infoBankChannel) {

    }

    @Override
    protected Map<String, LrAccountCheckBatchSub> getBatchSubMap(LrAccountCheckBatch batch) {
        Map<String, LrAccountCheckBatchSub> batchSubMap = new HashMap<>();
        LrAccountCheckBatchSub lrAccountCheckBatchSub = new LrAccountCheckBatchSub();
        lrAccountCheckBatchSub.setBatchNo(batch.getBatchNo());
        lrAccountCheckBatchSub.setTradeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setBankTradeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setTradeAmount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setBankTradeAmount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setMistakeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setUnhandleMistakeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setCreateTime(DateUtil.asLocalDateTime(new Date()));

        lrAccountCheckBatchSub.setId(feignSequenceClient.nextId().toString());
        lrAccountCheckBatchSub.setTransType(ReconConstants.TransTypeEnum.RECHARGE.getCode());
        batchSubMap.put(ReconConstants.TransTypeEnum.RECHARGE.getCode(),lrAccountCheckBatchSub);

        LrAccountCheckBatchSub  lrAccountCheckBatchSub2 = new LrAccountCheckBatchSub();
        BeanUtils.copyProperties(lrAccountCheckBatchSub,lrAccountCheckBatchSub2);
        lrAccountCheckBatchSub2.setId(feignSequenceClient.nextId().toString());
        lrAccountCheckBatchSub2.setTransType(ReconConstants.TransTypeEnum.PAYOUT.getCode());
        batchSubMap.put(ReconConstants.TransTypeEnum.PAYOUT.getCode(),lrAccountCheckBatchSub2);

        LrAccountCheckBatchSub  lrAccountCheckBatchSub3 = new LrAccountCheckBatchSub();
        BeanUtils.copyProperties(lrAccountCheckBatchSub,lrAccountCheckBatchSub3);
        lrAccountCheckBatchSub3.setId(feignSequenceClient.nextId().toString());
        lrAccountCheckBatchSub3.setTransType(ReconConstants.TransTypeEnum.EXCHANGE.getCode());
        batchSubMap.put(ReconConstants.TransTypeEnum.EXCHANGE.getCode(),lrAccountCheckBatchSub3);
        return batchSubMap;
    }
}
