package com.liquidnet.service.reconciliation.strategy.funddata.impl;

import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatch;
import com.liquidnet.service.reconciliation.entity.LrFundflowCurrencyCloud;
import com.liquidnet.service.reconciliation.entity.LrFundflowLiquidnetWallet;
import com.liquidnet.service.reconciliation.service.ILrFundflowCurrencyCloudService;
import com.liquidnet.service.reconciliation.strategy.funddata.IGetFundDataStrategy;
import com.liquidnet.service.reconciliation.strategy.funddata.annotation.StrategyGetFundDataHandler;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: currencyCloud
 * @class: CurrencyCloudGetFundDataStrategyImpl
 * @Package com.liquidnet.service.reconciliation.strategy.transtype.impl
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:58
 */
@Component
@StrategyGetFundDataHandler(BankChannelEnum.CURRENCY_CLOUD)
public class GetFundDataStrategyCurrencyCloudImpl implements IGetFundDataStrategy {
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @Autowired
    private ILrFundflowCurrencyCloudService lrFundflowCurrencyCloudService;

    @Override
    public List<ReconciliationEntityVo> getTransFundData(LrAccountCheckBatch batch, String bankChannel, Date billDate) {
        List<LrFundflowCurrencyCloud>  fundFlowList = lrFundflowCurrencyCloudService.list();

        //保存批次及明细信息
        lrFundflowCurrencyCloudService.saveBatch(fundFlowList);

        //转换为公共对象
        List<ReconciliationEntityVo> reconList = new ArrayList<>();
        fundFlowList.stream().forEach(fundRecord ->{
            ReconciliationEntityVo reconVo = ReconciliationEntityVo.getNew();
            reconVo.setId(feignSequenceClient.nextId().toString());
//            reconVo.setBankChannel();
//            reconVo.setBatchNo();
//            reconVo.setBillDate();
//            reconVo.setOrderNo();
//            reconVo.setTransactionId();
//            reconVo.setTransType();
//            reconVo.setCurrency();
//            reconVo.setAmount();
//            reconVo.setCostFee();
//            reconVo.setRefundAmount();
//            reconVo.setTradeStatus();
//            reconVo.setRefTransId();
//            reconVo.setCheckResult();
//            reconVo.setOrderTime();
//            reconVo.setTransDate();
//            reconVo.setTransTime();
//            reconVo.setBankOrderNo();
//            reconVo.setBankTrxNo();
            reconList.add(reconVo);
        });
        return reconList;
    }
}
