package com.liquidnet.service.reconciliation.strategy.parser;

import com.liquidnet.service.reconciliation.strategy.transtype.ITransTypeStrategy;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 数据解析上下文
 * @class: TransTypeStrategyContext
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:35
 */
@Component
public class DataParserStrategyContext {
    private final Map<String, ITransTypeStrategy> handlerMap = new HashMap<>();

    public ITransTypeStrategy getStrategy(String code) {
        return handlerMap.get(code);
    }

    public void putStrategy(String code, ITransTypeStrategy strategy) {
        handlerMap.put(code, strategy);
    }
}
