package com.liquidnet.service.reconciliation.strategy.transtype;

import com.liquidnet.service.reconciliation.strategy.transtype.annotation.StrategyTransTypeHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 服务启动初始化策略容器-交易类型
 * @class: TransTypeStrategyListener
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:38
 */
@Component
public class TransTypeStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyTransTypeHandler.class);
        TransTypeStrategyContext strategyContext = event.getApplicationContext().getBean(TransTypeStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyTransTypeHandler typeHandler = bean.getClass().getAnnotation(StrategyTransTypeHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (ITransTypeStrategy) bean);
        });
    }
}