package com.liquidnet.service.reconciliation.service.test;

import com.liquidnet.service.reconciliation.constant.ReconConstants.TransTypeEnum;
import com.liquidnet.service.reconciliation.strategy.transtype.ITransTypeStrategy;
import com.liquidnet.service.reconciliation.strategy.transtype.TransTypeStrategyContext;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: StrategyTest
 * @Package com.liquidnet.service.reconciliation.service.test
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/16 2:03 下午
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class StrategyTest {
    @Resource
    private TransTypeStrategyContext transTypeStrategyContext;

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Test
    public void testTransType(){
        String code = TransTypeEnum.PAYOUT.getCode();
        ITransTypeStrategy strategy = transTypeStrategyContext.getStrategy(code);
        if (strategy == null) {
            log.info("不支持的格式");
        }
        strategy.doBusiness();
    }
}
