package com.liquidnet.service.slime.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "SlimeAuthorizationPerformanceVo", description = "演出纬度权限聚合")
@Data
public class SlimeAuthorizationPerformanceVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -225012446820470899L;

    @ApiModelProperty(value = "演出ID")
    private String performanceId;

    @ApiModelProperty(value = "权利人")
    private String uid;

    @ApiModelProperty(value = "权利人演出所有角色")
    private List<String> uidRoles;

    @ApiModelProperty(value = "权利人演出所有权限")
    private List<String> permissionIds;

    private static final SlimeAuthorizationPerformanceVo obj = new SlimeAuthorizationPerformanceVo();

    public static SlimeAuthorizationPerformanceVo getNew() {
        try {
            return (SlimeAuthorizationPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SlimeAuthorizationPerformanceVo();
    }
}
