package com.liquidnet.service.reconciliation.util.excel2bean.base;

import com.liquidnet.service.reconciliation.util.excel2bean.annotation.ExcelCell;
import org.apache.commons.lang.StringUtils;

import java.text.DecimalFormat;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: DoubleConvertData
 * @class: DoubleConvertData
 * @Package com.liquidnet.service.reconciliation.util.excel2bean.base
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/22 10:19
 */
public class DoubleConvertData implements ConvertData {
    public Object convertData(ExcelCell excelCell, Object origin) throws Exception {
        Object result = null;
        if(StringUtils.isNotEmpty(excelCell.formatPattern())) {
            result = origin != null ? new DecimalFormat(excelCell.formatPattern()).parse(origin.toString()).doubleValue():0;
        } else {
            result = origin != null ? Double.valueOf(origin.toString()) : 0;
        }
        return result;
    }
}
