package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.param.admin.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class AdamMemberServiceAdminImpl extends ServiceImpl<AdamMemberMapper, AdamMember> implements IAdamMemberAdminService {
    @Autowired
    AdamMemberMapper adamMemberMapper;
//    @Autowired
//    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public void add(AdamMemberParam parameter) {
        AdamMember adamMember = new AdamMember();
        BeanUtils.copyProperties(parameter, adamMember);

        List<AdamMember> existList = adamMemberMapper.selectList(Wrappers.lambdaQuery());

        adamMember.setMemberId(CollectionUtils.isEmpty(existList) ? "1" : IDGenerator.nextSnowId());
        adamMember.setType(1);
        adamMember.setStartNo(10000);
        adamMember.setCreatedAt(LocalDateTime.now());
        adamMember.setUpdatedAt(LocalDateTime.now());

        AdamMemberVo vo = AdamMemberVo.getNew().copy(adamMember);

        adamMemberMapper.insert(adamMember);
//        mongoTemplate.insert(vo, AdamMemberVo.class.getSimpleName());
        redisUtil.set(AdamRedisConst.INFO_MEMBER_CATEGORY.concat(vo.getMemberId()), vo);
    }

    @Override
    public boolean edit(AdamMemberParam parameter) {
        AdamMember adamMember = new AdamMember();
        BeanUtils.copyProperties(parameter, adamMember);
        adamMember.setUpdatedAt(LocalDateTime.now());
        AdamMemberVo vo = AdamMemberVo.getNew().copy(adamMember);

        LambdaQueryWrapper<AdamMember> updateMemberWrapper = Wrappers.lambdaQuery(AdamMember.class).eq(AdamMember::getMemberId, parameter.getMemberId());
        if (adamMemberMapper.update(adamMember, updateMemberWrapper) > 0) {
            redisUtil.set(AdamRedisConst.INFO_MEMBER_CATEGORY.concat(vo.getMemberId()), vo);
            return true;
        }
        return false;
    }
}
