package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 店铺认证信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreCertification implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 证件类型[1-二代居民身份证]
     */
    private String personCertType;

    /**
     * 证件姓名
     */
    private String personName;

    /**
     * 证件号
     */
    private String personCertCode;

    /**
     * 证件有效期
     */
    private LocalDateTime personCertValidity;

    /**
     * 证件是否长期有效[0-否|1-是]
     */
    private String personCertLasting;

    /**
     * 证件正面照
     */
    private String personCertFpic;

    /**
     * 证件背面照
     */
    private String personCertBpic;

    /**
     * 证件背面照
     */
    private String personCertSpic;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    /**
     * 省id
     */
    private String provinceId;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 市id
     */
    private String cityId;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 县id
     */
    private String countyId;

    /**
     * 县名称
     */
    private String countyName;

    /**
     * 详细地址
     */
    private String busAddress;

    /**
     * 商户名称
     */
    private String busName;

    /**
     * 统一社会信用代码
     */
    private String busCertCode;

    /**
     * 营业执照有效期
     */
    private LocalDateTime busCertValidity;

    /**
     * 证件是否长期有效[0-否|1-是]
     */
    private String busCertLasting;

    /**
     * 营业执照照片
     */
    private String busCertPic;

    /**
     * 资质证书
     */
    private String busQualityPic;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
