package com.liquidnet.service.sweet.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetDoudou;
import com.liquidnet.service.sweet.param.SweetDouDouCheckParam;
import com.liquidnet.service.sweet.param.SweetDouDouParam;
import com.liquidnet.service.sweet.vo.SweetDouDouActiveVo;
import com.liquidnet.service.sweet.vo.SweetDouDouVo;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * doudou预约签名CD记录表 服务类
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-06-04
 */
public interface ISweetDoudouService extends IService<SweetDoudou> {

    ResponseDto<SweetDouDouVo> info();

    ResponseDto<SweetDouDouVo> create(@Valid SweetDouDouParam param);

    ResponseDto check(SweetDouDouCheckParam param);

    ResponseDto<SweetDouDouVo> detail(SweetDouDouCheckParam param);

    boolean winningUpload(MultipartFile file);

    ResponseDto<List<SweetDouDouActiveVo>> getActiveList();
}
