package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.param.SweetDouDouCheckParam;
import com.liquidnet.service.sweet.param.SweetDouDouParam;
import com.liquidnet.service.sweet.service.ISweetDoudouService;
import com.liquidnet.service.sweet.vo.SweetDouDouActiveVo;
import com.liquidnet.service.sweet.vo.SweetDouDouVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * doudou预约签名CD记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-06-04
 */
@Api(tags = "活动-doudou")
@RestController
@RequestMapping("/doudou")
public class SweetDoudouController {
    @Autowired
    private ISweetDoudouService iSweetDoudouService;

    @GetMapping("/active/list")
    @ApiOperation("获取活动列表")
    public ResponseDto<List<SweetDouDouActiveVo>> getActiveList() {
        return iSweetDoudouService.getActiveList();
    }

    @GetMapping("")
    @ApiOperation("获取用户预约详情")
    public ResponseDto<SweetDouDouVo> info(@RequestParam(value = "activeId") String activeId) {
        return iSweetDoudouService.info();
    }

    @PostMapping("")
    @ApiOperation("预约")
    public ResponseDto<SweetDouDouVo> create(@Valid @RequestBody SweetDouDouParam param) {
        return iSweetDoudouService.create(param);
    }

// ################################## 二维码核销 ###############################################

    @PostMapping("/detail")
    @ApiOperation("核验-码详情")
    public ResponseDto<SweetDouDouVo> detail(@Valid @RequestBody SweetDouDouCheckParam param) {
        return iSweetDoudouService.detail(param);
    }

    @PostMapping("/check")
    @ApiOperation("核销")
    public ResponseDto check(@Valid @RequestBody SweetDouDouCheckParam param) {
        return iSweetDoudouService.check(param);
    }

    @PostMapping("/winning/upload")
    @ApiOperation("中签上传")
    public ResponseDto<Boolean> winningUpload(@RequestPart(value = "file") MultipartFile file) {
        return ResponseDto.success(iSweetDoudouService.winningUpload(file));
    }
}
