package com.liquidnet.service.merchant.constant;

public class MerchantPermissionConst {

    // 某演出通过审核后，分配演出权限，场地方审核演出为'待审核的演出'与'演出'不同
    public enum PerformancePermission {
        READ("1", "查看"),
        EDIT("2", "编辑"),
        SUBMIT("3", "提交"),
        ONLINE("4", "上线"),
        OFFLINE("5", "下线"),
        SALES("6", "销售"),
        CHECK("7", "验票"),
        ACCREDIT("8", "授权");

        private final String id;
        private final String name;

        PerformancePermission(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return id;
        }

        public String getName() {
            return name;
        }
    }
}
