package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinNftOrderAdminServiceImpl;
import com.liquidnet.service.goblin.dto.admin.GoblinNftOrderListDto;
import com.liquidnet.service.goblin.dto.admin.GoblinNftOrderRefundListDto;
import com.liquidnet.service.goblin.param.admin.GoblinNftOrderListParam;
import com.liquidnet.service.goblin.param.admin.GoblinNftOrderRefundListParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * NFT订单Controller
 *
 * @author jiangxiulong
 * @date 2022-03-31
 */
@Controller
@RequestMapping("/goblin/nftOrder")
public class GoblinNftOrderController extends BaseController {
    private String prefix = "zhengzai/goblin/nftOrder";

    @Autowired
    private GoblinNftOrderAdminServiceImpl goblinNftOrderAdminService;

    // NFT订单列表
    @GetMapping("/orderView")
    public String orderView() {
        return prefix + "/orderView";
    }

    @Log(title = "NFT订单", businessType = BusinessType.LIST)
    @RequiresPermissions("goblin:nftOrder:list")
    @PostMapping("/orderList")
    @ResponseBody
    public TableDataInfo orderList(GoblinNftOrderListParam listParam) {
        startPage();
        PageInfo<GoblinNftOrderListDto> list = goblinNftOrderAdminService.orderList(listParam);
        return getDataTable(list.getList());
    }

    // NFT订单列表退款
    @GetMapping("/orderRefundView")
    public String orderRefundView() {
        return prefix + "/orderRefundView";
    }

    @Log(title = "NFT退款订单", businessType = BusinessType.LIST)
    @RequiresPermissions("goblin:nftOrderRefund:list")
    @PostMapping("/refundList")
    @ResponseBody
    public TableDataInfo refundList(GoblinNftOrderRefundListParam listParam) {
        startPage();
        PageInfo<GoblinNftOrderRefundListDto> list = goblinNftOrderAdminService.refundList(listParam);
        return getDataTable(list.getList());
    }

}
