package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinGoodsInfoVo", description = "商品SPU详情[不包含具体SKU，SKU详情参见'GoblinGoobsSkuInfoVo']")
@Data
public class GoblinGoodsInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4712015317981742851L;
    @ApiModelProperty(position = 10, value = "店铺ID")
    private String storeId;

    /** ---------------------------- 基本信息 ---------------------------- **/

    @ApiModelProperty(position = 11, value = "商品名称[128]")
    private String name;

    @ApiModelProperty(position = 12, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 13, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 14, value = "商品三级分类ID[30]")
    private String cateTid;

    @ApiModelProperty(position = 15, value = "商品简介[256]")
    private String intro;

    @ApiModelProperty(position = 16, value = "商品标签列表")
    private List<GoblinGoodsTagVo> tagVoList;
    @ApiModelProperty(position = 17, value = "商品图片列表")
    private List<String> imageList;
    @ApiModelProperty(position = 18, value = "商品视频地址")
    private String video;

    /** ---------------------------- 价格库存 ---------------------------- **/

    @ApiModelProperty(position = 20, value = "规格展现方式[1-常规|2-组合]")
    private String specMode;
//    @ApiModelProperty(position = 21, value = "SKU规格信息")
//    private List<GoblinStoreMgtGoodsAddSkuParam> skuParamList;
    @ApiModelProperty(position = 22, value = "物流模版")
    private String logisticsTemplate;
    @ApiModelProperty(position = 23, value = "商品编码[默认为系统编码，也可手动输入商家自己的编码]")
    private String spuNo;

    /** ---------------------------- 商品介绍 ---------------------------- **/

    @ApiModelProperty(position = 24, value = "商品详情", example = "商品详情...")
    private String details;

    /** ---------------------------- 销售属性 ---------------------------- **/

    @ApiModelProperty(position = 25, value = "上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]")
    private String shelvesHandle;
    @ApiModelProperty(position = 26, value = "预约上架时间[上架处理方式为3-预约定时上架时需要指定]")
    private String shelvesTime;
    @ApiModelProperty(position = 27, value = "商品有效期[YYYY-MM-DD]")
    private String spuValidity;
    @ApiModelProperty(position = 28, value = "是否虚拟商品[0-否|1-是]")
    private String virtualFlg;

    /** ---------------------------- 服务保障 ---------------------------- **/

    @ApiModelProperty(position = 29, value = "商品服务支持ID列表")
    private List<GoblinGoodsServiceSupportVo> serviceSupportVoList;

    /** ---------------------------- 专属标签 ---------------------------- **/

    @ApiModelProperty(position = 30, value = "商品关联音乐人、艺术家、IP列表")
    private List<GoblinGoodsExtagVo> extagVoList;

    private static final GoblinGoodsInfoVo obj = new GoblinGoodsInfoVo();
    public static GoblinGoodsInfoVo getNew() {
        try {
            return (GoblinGoodsInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsInfoVo();
        }
    }
}
