package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 官方(平台)营销表[活动]表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinSelfMarketingVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "官方营销表id")
    private String selfMarketId;
    @ApiModelProperty(value = "营销名称")
    private String name;
    @ApiModelProperty(value = "营销类型[1-正在下单]")
    private Integer type;
    @ApiModelProperty(value = "活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]")
    private Integer status;
    @ApiModelProperty(value = "营销描述")
    private String desc;
    @ApiModelProperty(value = "营销开始时间")
    private String startTime;
    @ApiModelProperty(value = "营销结束时间营销为定金预售的时候，该时间也是第二阶段付款的时间营销为全款预售的时候，该时间也是发货时间")
    private String endTime;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    private static final GoblinSelfMarketingVo obj = new GoblinSelfMarketingVo();

    public static GoblinSelfMarketingVo getNew() {
        try {
            return (GoblinSelfMarketingVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSelfMarketingVo();
        }
    }
}
