package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtThumbVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@ApiSupport(order = 149002)
@Api(tags = "店铺管理")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt")
public class GoblinStoreMgtController {

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "店铺简易信息列表")
    @GetMapping(value = {"list"})
    public ResponseDto<List<GoblinStoreMgtThumbVo>> thumbList() {

        return ResponseDto.success(null);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "店铺管理:店铺详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID"),
    })
    @GetMapping(value = {"info"})
    public ResponseDto<GoblinStoreMgtInfoVo> info(String storeId) {

        return ResponseDto.success(null);
    }
}
