package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseItemParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPurchasingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStorePurchasingService;
import com.sun.org.apache.xpath.internal.operations.Bool;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 商铺活动管理
 */
@Slf4j
@RestController
@Api(tags = "活动-限时秒杀")
@RequestMapping("store/marketing")
public class GoblinStorePurchasingController {

    @Autowired
    IGoblinStorePurchasingService goblinStorePurchasingService;

    @GetMapping("purchasing/list")
    @ApiOperation("活动详情-限时秒杀列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "page", value = "页数", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "purchaseName", value = "活动名称", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "startTime", value = "活动开始时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "endTime", value = "活动结束时间", example = ""),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "createdAt", value = "活动创建时间", example = ""),
    })
    public ResponseDto<PageInfo<GoblinPurchasingVo>> purchasingList(@RequestParam(value = "page", required = false) @Valid Integer page,
                                                                    @RequestParam(value = "purchaseName", required = false) String purchaseName,
                                                                    @RequestParam(value = "status", required = false) Integer status,
                                                                    @RequestParam(value = "startTime", required = false) String st,
                                                                    @RequestParam(value = "endTime", required = false) String et,
                                                                    @RequestParam(value = "createdAt", required = false) String ct) {
        PageInfo<GoblinPurchasingVo> data = new PageInfo<>();
        data.setList(goblinStorePurchasingService.purchasingList(page, purchaseName, status, st, et, ct).getData());
        return ResponseDto.success(data);
    }

    @PutMapping("purchasing/status")
    @ApiOperation("活动操作-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "活动状态[0-等待开始|7-停用]", example = ""),
    })
    public ResponseDto<Boolean> purchasingStatus(@RequestParam(value = "marketId") @Valid String marketId,
                                                 @RequestParam(value = "status") @Valid Integer status) {
        return goblinStorePurchasingService.purchasingStatus(marketId, status);
    }

    @PostMapping("purchasing")
    @ApiOperation("创建活动-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<Boolean> purchasingInsert(GoblinStorePurchaseParam goblinStorePurchaseParam) {
        return goblinStorePurchasingService.purchasingInsert(goblinStorePurchaseParam.getName(), goblinStorePurchaseParam.getStoreId(), goblinStorePurchaseParam.getStartTime(), goblinStorePurchaseParam.getEndTime(), goblinStorePurchaseParam.getIsPre(), goblinStorePurchaseParam.getPreTime());
    }

    @PutMapping("purchasing")
    @ApiOperation("修改活动-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<String> purchasingUpdate(GoblinStorePurchaseParam goblinStorePurchaseParam) {
        goblinStorePurchasingService.purchasingUpdate(goblinStorePurchaseParam.getMarketId(), goblinStorePurchaseParam.getName(), goblinStorePurchaseParam.getStoreId(), goblinStorePurchaseParam.getStartTime(), goblinStorePurchaseParam.getEndTime(), goblinStorePurchaseParam.getIsPre(), goblinStorePurchaseParam.getPreTime());
        return ResponseDto.success();
    }

    @GetMapping("purchasing/details")
    @ApiOperation("活动详情-限时秒杀")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<GoblinPurchasingVo> purchasingDetails(@RequestParam("marketId") @Valid String marketId) {
        return goblinStorePurchasingService.purchasingDetails(marketId);
    }

    @GetMapping("purchasing/sku")
    @ApiOperation("活动详情-限时秒杀-sku列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1"),
    })
    public ResponseDto<String> purchasingSkuList(@RequestParam("marketId") @Valid String marketId,
                                                 @RequestParam("page") @Valid Integer page) {
        return goblinStorePurchasingService.purchasingSkuList(marketId, page);
    }

    @PostMapping("purchasing/sku")
    @ApiOperation("活动详情-限时秒杀-sku配置")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ResponseBody
    public ResponseDto<Boolean> purchasingSkuOperation(List<GoblinStorePurchaseItemParam> params) {
        return goblinStorePurchasingService.purchasingSkuOperation(params);
    }

    @DeleteMapping("purchasing/sku")
    @ApiOperation("活动详情-限时秒杀-sku删除")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "skuId", value = "skuId", example = "1"),
    })
    public ResponseDto<Boolean> purchasingSkuDel(@RequestParam("marketId") @Valid String marketId,
                                                 @RequestParam("skuId") @Valid String skuId) {
        return goblinStorePurchasingService.purchasingSkuDel(marketId, skuId);
    }

}
