package com.liquidnet.service.goblin.util;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketingZhengzaiRelationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class GoblinRedisUtils {
    @Autowired
    RedisUtil redisUtil;

    /**
     * 获取 当前商铺能参与的官方活动id列表
     *
     * @param storeId
     * @return
     */
    public List<String> getStoreZhengzaiRelation(String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (List<String>) obj;
        }
    }

    /**
     * 正在下单 可参加商户关系 详情
     *
     * @param selfMarketId
     * @param storeId
     */
    public GoblinMarketingZhengzaiRelationVo getZhengzaiRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinMarketingZhengzaiRelationVo) obj;
        }
    }

    /**
     * 正在下单 可参加商户 详情
     *
     * @param selfMarketId
     */
    public GoblinSelfMarketingVo getSelfMarket(String selfMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinSelfMarketingVo) obj;
        }
    }
}
