package com.liquidnet.service.goblin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateUpdateParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateVo;

import java.math.BigInteger;
import java.util.List;

/**
 * <p>
 * 预约表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
public interface IGoblinGoodsAnticipateService {

    /**
     * 查询预约
     */
    ResponseDto<PageInfo<GoblinGoodsAnticipateValueVo>> list(GoblinGoodsAnticipateValueParam goodsAnticipateValueParam);

    /**
     * 新增预约
     */
    ResponseDto<Object> add(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam);

    /**
     * 修改预约人数
     */
    ResponseDto<Object> updatePeople(String antId, BigInteger people);

    /**
     * 删除预约
     */
    ResponseDto<Object> delete(String skuId);

    /**
     * 用户预约
     */
    ResponseDto<Object> userAbout(String skuId, String uid, String phone, Integer state,String url);

}
