package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtGoodsCouponEditSkuParam", description = "商品管理:编辑券类商品:编辑券SKU入参")
@Data
public class GoblinStoreMgtGoodsCouponEditSkuParam implements Serializable {
    private static final long serialVersionUID = 8174428924922310702L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "商品ID[64]")
    @NotNull(message = "商品ID不能为空")
    private String spuId;
    @ApiModelProperty(position = 12, required = true, value = "单品ID[编辑时必传]")
    @NotNull(message = "商品SKU_ID不能为空")
    private String skuId;
    @ApiModelProperty(position = 13, required = true, value = "单品现价[20,2]")
    @Digits(integer = 3, fraction = 2, message = "参数'单品现价'无效")
    @DecimalMin(value = "0.01", message = "参数'单品现价'必须为大于0")
    private BigDecimal price;
    @ApiModelProperty(position = 14, required = true, value = "限量[0-无限制|X:限购数量]")
    @Min(value = 0, message = "参数'限购数量'不能小于0")
    @NotNull(message = "参数'限购数量'不可为空")
    private Integer buyLimit;


    @ApiModelProperty(position = 15, required = false, value = "总库存")
    private Integer stock;
    @ApiModelProperty(position = 16, required = false, value = "总库存")
    private Integer skuStock;
    @ApiModelProperty(position = 17, required = false, value = "加减库存")
    private Integer operStock;

    /**
     * ---------------------------- 券类商品-代金券属性 ----------------------------
     */

    @ApiModelProperty(position = 18, required = true, value = "是否实名[0-否｜1-是，表示该商品需要实名关联]", example = "1")
    @Pattern(regexp = "\\b(0|1)\\b", message = "参数'是否实名'无效")
    private String isTrueName;
    @ApiModelProperty(position = 19, required = true, value = "适用范围[101-音乐节｜102-小型演出（livehouse演出）｜103-巡演]")
    @Pattern(regexp = "\\b(101|102|103)\\b", message = "参数'适用范围'无效")
    private String useScope;
    @ApiModelProperty(position = 20, required = true, value = "面值", example = "99.00")
    @Digits(integer = 3, fraction = 2, message = "参数'面值'无效")
    @DecimalMin(value = "0.01", message = "参数'面值'必须为大于0")
    private BigDecimal valFace;
    @ApiModelProperty(position = 21, required = true, value = "结束时间[yyyy-MM-dd HH:mm:ss]", example = "2024-01-01 00:00:00")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开始时间格式有误")
    @NotNull(message = "参数'开始时间'不可为空")
    private String effectAt;
    @ApiModelProperty(position = 22, required = true, value = "结束时间[yyyy-MM-dd HH:mm:ss]", example = "2024-12-31 00:00:00")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "结束时间格式有误")
    @NotNull(message = "参数'结束时间'不可为空")
    private String expireAt;


    public GoblinGoodsSkuInfoVo initEditGoodsSkuInfoVo() {
        GoblinGoodsSkuInfoVo goodsSkuInfoVo = GoblinGoodsSkuInfoVo.getNew();
        goodsSkuInfoVo.setSkuType(2);
        goodsSkuInfoVo.setSkuId(this.getSkuId());
        goodsSkuInfoVo.setPrice(this.getPrice());
        goodsSkuInfoVo.setPriceMember(this.getPrice());
        goodsSkuInfoVo.setBuyLimit(this.getBuyLimit());
        goodsSkuInfoVo.setStock(this.getStock());
        goodsSkuInfoVo.setSkuStock(this.getSkuStock());
        goodsSkuInfoVo.setIsTrueName(Integer.valueOf(this.getIsTrueName()));
        goodsSkuInfoVo.setUseScope(Integer.valueOf(this.getUseScope()));
        goodsSkuInfoVo.setValFace(this.getValFace());
        goodsSkuInfoVo.setEffectAt(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getEffectAt()));
        goodsSkuInfoVo.setExpireAt(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getExpireAt()));
        return goodsSkuInfoVo;
    }
}
