package com.liquidnet.service.platform.service.impl.adam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.AbstractRedisUtil;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamPosScanitVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.entity.AdamUserInfo;
import com.liquidnet.service.adam.mapper.AdamUserInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatformAdamUserPosService extends ServiceImpl<AdamUserInfoMapper, AdamUserInfo> {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
//    @Autowired
//    private AdamUserMemberMapper adamUserMemberMapper;
//    @Autowired
//    private AdamUserMapper adamUserMapper;

    public AdamPosScanitVo scanitProcess(String code) {
        LambdaQueryWrapper<AdamUserInfo> userInfoLambdaQueryWrapper = Wrappers.lambdaQuery(AdamUserInfo.class);
        userInfoLambdaQueryWrapper.eq(AdamUserInfo::getQrCode, code);
        userInfoLambdaQueryWrapper.select(AdamUserInfo::getUid);
        AdamUserInfo userInfo = this.getOne(userInfoLambdaQueryWrapper);

        AdamPosScanitVo scanitVo = AdamPosScanitVo.getNew();
        if (null != userInfo) {
//            LambdaQueryWrapper<AdamUser> adamUserLambdaQueryWrapper = Wrappers.lambdaQuery(AdamUser.class);
//            adamUserLambdaQueryWrapper.eq(AdamUser::getUid, userInfo.getUid());
//            adamUserLambdaQueryWrapper.eq(AdamUser::getState, 1);
//            adamUserLambdaQueryWrapper.select(AdamUser::getUid, AdamUser::getMobile);
//            AdamUser user = adamUserMapper.selectOne(adamUserLambdaQueryWrapper);
            AbstractRedisUtil redisAdamUtil = redisDataSourceUtil.getRedisAdamUtil();
            AdamUserInfoVo userInfoVo = (AdamUserInfoVo) redisAdamUtil.get(AdamRedisConst.INFO_USER.concat(userInfo.getUid()));
            if (null != userInfoVo) {
                scanitVo.setNickname(userInfoVo.getNickname());
                scanitVo.setMobile(userInfoVo.getMobile());
                scanitVo.setUid(userInfoVo.getUid());

//                LambdaQueryWrapper<AdamUserMember> userMemberLambdaQueryWrapper = Wrappers.lambdaQuery(AdamUserMember.class);
//                userMemberLambdaQueryWrapper.eq(AdamUserMember::getUid, userInfo.getUid());
//                userMemberLambdaQueryWrapper.eq(AdamUserMember::getState, 1);
//                userMemberLambdaQueryWrapper.select(AdamUserMember::getUid,
//                        AdamUserMember::getState,
//                        AdamUserMember::getExpiryAt,
//                        AdamUserMember::getCreatedAt,
//                        AdamUserMember::getUpdatedAt
//                );
//                AdamUserMember userMember = adamUserMemberMapper.selectOne(userMemberLambdaQueryWrapper);
                AdamUserMemberVo userMemberVo = (AdamUserMemberVo) redisAdamUtil.get(AdamRedisConst.INFO_USER_MEMBER.concat(userInfo.getUid()));
                if (null == userMemberVo) {
                    scanitVo.setStageMarker(0);
                } else {
                    if (userMemberVo.isActive()) {
                        scanitVo.setStageMarker(userMemberVo.isOldMember() ? 10 : 11);
                    } else {
                        scanitVo.setStageMarker(2);
                    }
                }
            }

        }

        return scanitVo;
    }
}
