package com.liquidnet.service.example.controller;

import com.alibaba.fastjson.JSON;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.liquidnet.service.feign.account.api.FeignAccountClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "example")
@RestController
@RequestMapping("emp")
public class ExampleController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FeignAccountClient feignAccountClient;
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Simple test")
    @GetMapping(value = "test")
    public ResponseEntity<?> test(String str) {
        log.info("This is `service-example` api.test: {}", str);
        return ResponseEntity.ok("This is `service-example` api.test: " + str);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "Feign account api test")
    @GetMapping(value = "test/feign-account")
    public ResponseEntity<?> testFeignAccount(String str) {
        log.info("This is `service-example` api.test:feign-account: {}", str);
        Object feignAccountRst = null;
        {
//            WalletQueryParam walletQueryParam = new WalletQueryParam();
//            walletQueryParam.setChannelId("50001");
//            walletQueryParam.setBizType("000");
//            walletQueryParam.setUserExtId("1001");
//            feignAccountRst = feignAccountClient.trading(walletQueryParam.txData());
//            log.info("This is the result of a remote call to the `service-account` api.query:\n\n{}\n", JSON.toJSONString(feignAccountRst));
        }
        {
            feignAccountRst = feignAccountClient.queryOne(str);
            log.info("This is the result of a remote call to the `service-account` api.queryOne:\n\n{}\n", JSON.toJSONString(feignAccountRst));
        }
        return ResponseEntity.ok(feignAccountRst);
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "Feign sequence api test")
    @GetMapping(value = "test/feign-sequence")
    public ResponseEntity<?> testFeignSequence(String str) {
        log.info("This is `service-example` api.test:feign-sequence: {}", str);
        Object feignSequenceRst = null;
        {
            feignSequenceRst = feignSequenceClient.nextIncrId(str);
            log.info("This is the result of a remote call to the `service-sequence`.nextIncrId:\n\n{}\n", JSON.toJSONString(feignSequenceRst));
        }
        {
            feignSequenceRst = feignSequenceClient.nextId();
            log.info("This is the result of a remote call to the `service-sequence`.nextId:\n\n{}\n", JSON.toJSONString(feignSequenceRst));
        }
        {
            feignSequenceRst = feignSequenceClient.nextId(10);
            log.info("This is the result of a remote call to the `service-sequence`.test(10):\n\n{}\n", JSON.toJSONString(feignSequenceRst));
        }
        return ResponseEntity.ok(feignSequenceRst);
    }
}
