package com.liquidnet.service.example.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.example.entity.User;
import com.liquidnet.service.example.mapper.UserMapper;
import com.liquidnet.service.example.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author lightnet
 * @since 2020-09-08
 */
@Service("userServiceCancelImpl")
public class UserServiceCancelImpl extends ServiceImpl<UserMapper, User> implements IUserService {

    @Autowired
    private UserMapper userMapper;

    @Override
    @Transactional
    public int insert(User user) {
        log.debug("开始执行UserServiceCancelImpl insert");
        return userMapper.delete(new QueryWrapper(user));
    }

}
