package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: nft转让最新记录
 * @class: GalaxyTransferNftInfoBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/12 13:36
 */
@Data
public class GalaxyTransferNftInfoBo implements Serializable,Cloneable{
    /**
     * nft唯一资产碎片id
     */
    private String nftId;
    /**
     * nft当前拥有者addr
     */
    private String ownerAddr;
    /**
     * nft历史拥有者addr
     */
    private String fromAddr;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 路由类型
     */
    private String routerType;
    /**
     * 创建时间
     */
    private String createdAt;
    /**
     * 修改时间
     */
    private String updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyTransferNftInfoBo obj = new GalaxyTransferNftInfoBo();

    public static GalaxyTransferNftInfoBo getNew() {
        try {
            return (GalaxyTransferNftInfoBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyTransferNftInfoBo();
        }
    }
}
