package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.CommodityOrderExportDao;
import com.liquidnet.service.kylin.dao.MemberOrderExportDao;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderExportVo implements Serializable, Cloneable {
    @Excel(name = "演出名称/购买名称", cellType = Excel.ColumnType.STRING)
    private String performanceTitle;
    @Excel(name = "手机号", cellType = Excel.ColumnType.STRING)
    private String userMobile;
    @Excel(name = "姓名", cellType = Excel.ColumnType.STRING)
    private String userName;
    @Excel(name = "订单号", cellType = Excel.ColumnType.STRING)
    private String orderCode;
    @Excel(name = "商户订单号", cellType = Excel.ColumnType.STRING)
    private String code;
    @Excel(name = "商户订单号", cellType = Excel.ColumnType.STRING)
    private String payCode;
    @Excel(name = "微信/支付宝订单号", cellType = Excel.ColumnType.STRING)
    private String paymentId;
    @Excel(name = "状态", cellType = Excel.ColumnType.STRING)
    private String status;
    @Excel(name = "支付平台", cellType = Excel.ColumnType.STRING)
    private String paymentType;
    @Excel(name = "演出类型", cellType = Excel.ColumnType.STRING)
    private String type;
    @Excel(name = "票种名称", cellType = Excel.ColumnType.STRING)
    private String title1;
    @Excel(name = "场次", cellType = Excel.ColumnType.STRING)
    private String title2;
    @Excel(name = "单价", cellType = Excel.ColumnType.STRING)
    private String price;
    @Excel(name = "快递费", cellType = Excel.ColumnType.STRING)
    private String priceExpress;
    @Excel(name = "购票数", cellType = Excel.ColumnType.STRING)
    private String number;
    @Excel(name = "退票数", cellType = Excel.ColumnType.STRING)
    private String refundNumber;
    @Excel(name = "实付金额", cellType = Excel.ColumnType.STRING)
    private String priceActual;
    @Excel(name = "退款金额", cellType = Excel.ColumnType.STRING)
    private String priceRefund;
    @Excel(name = "退款时间", cellType = Excel.ColumnType.STRING)
    private String refundAt;
    @Excel(name = "退款原因", cellType = Excel.ColumnType.STRING)
    private String reject;
    @Excel(name = "支付时间", cellType = Excel.ColumnType.STRING)
    private String timePay;
    @Excel(name = "创建时间", cellType = Excel.ColumnType.STRING)
    private String createdAt;
    @Excel(name = "更新时间", cellType = Excel.ColumnType.STRING)
    private String updatedAt;
    @Excel(name = "商品名称", cellType = Excel.ColumnType.STRING)
    private String name;


    private static final OrderExportVo obj = new OrderExportVo();

    public static OrderExportVo getNew() {
        try {
            return (OrderExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderExportVo();
    }

    public OrderExportVo copyOrderExportVo(OrderExportDao source) {
        this.setPerformanceTitle(source.getPerformanceTitle());
        this.setUserMobile(source.getUserMobile());
        this.setUserName(source.getUserName());
        this.setOrderCode(source.getOrderCode());
        this.setCode(source.getCode());
        this.setPayCode(source.getPayCode());
        this.setPaymentId(source.getPaymentId());
        this.setStatus(source.getStatus());
        this.setPaymentType(source.getPaymentType());
        this.setType(source.getType());
        this.setTitle1(source.getTitle1());
        this.setTitle2(source.getTitle2());
        this.setPrice(source.getPrice());
        this.setPriceExpress(source.getPriceExpress());
        this.setNumber(source.getNumber());
        this.setRefundNumber(source.getRefundNumber());
        this.setPriceActual(source.getPriceActual());
        this.setPriceRefund(source.getPriceRefund());
        this.setRefundAt(source.getRefundAt());
        this.setReject(source.getReject());
        this.setTimePay(source.getTimePay());
        return this;
    }

    public OrderExportVo copyMemberOrderExportVo(MemberOrderExportDao source) {
        this.setCode(source.getPayNo());
        this.setPaymentId(source.getPaymentId());
        this.setPaymentType(source.getPayType());
        this.setStatus(source.getState());
        this.setPrice(source.getPrice());
        this.setTimePay(source.getPaymentAt());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setRefundAt(source.getRefundAt());
        this.setPriceRefund(source.getRefundPrice());
        return this;
    }

    public OrderExportVo copyCommodityOrderExportVo(CommodityOrderExportDao source) {
        this.setCode(source.getCode());
        this.setPaymentId(source.getPaymentId());
        this.setName(source.getName());
        this.setPaymentType(source.getPaymentType());
        this.setPriceActual(source.getPriceActual());
        this.setCreatedAt(source.getCreatedAt());
        this.setPriceExpress(source.getPriceExpress());
        this.setPriceRefund(source.getPriceRefund());
        this.setStatus(source.getStatus());
        this.setRefundAt(source.getRefundAt());
        return this;
    }


}
