package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinOrderLogVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderListVo;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.math.BigDecimal;

public interface IGoblinStoreOrderService {
    ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(Integer page,
                                                            String orderCode,
                                                            Integer type,
                                                            String cst,
                                                            String cet,
                                                            String expressContacts,
                                                            String phone,
                                                            Integer status);

    ResponseDto<GoblinStoreOrderListVo> orderDetails(String orderId);

    ResponseDto<Boolean> changeAddress(String orderId, String expressContacts, String expressPhone, String expressAddressDetail);

    ResponseDto<Boolean> changeSkuPrice(String orderId, String orderSkuId, BigDecimal price);
}
