package com.liquidnet.service.feign.platform.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PutMapping;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformCandyTaskClient",
        path = "platform",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformCandyTaskClient {

    @PutMapping("/candy/task/issue/coupons")
    ResponseDto<String> issueCoupons();
}
