package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.liquidnet.client.admin.zhengzai.kylin.dto.OpenDataSalesResponse;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OpenDataTicketSalesResponse;
import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceSalesDto;
import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceTicketSalesDto;
import com.liquidnet.client.admin.zhengzai.kylin.service.IOpenDataService;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@Slf4j
@Service
public class OpenDataServiceImpl implements IOpenDataService {

    @Value("${liquidnet.openData.host}")
    private String openDataHost;

    @Value("${liquidnet.openData.auth}")
    private String openDataAuth;

    @Override
    public List<PerformanceSalesDto> getPerformanceSalesInfo(List<String> performanceIdList) {
        HashMap<String, List<String>> map = new HashMap<>();
        map.put("performanceIds", performanceIdList);

        HttpHeaders headers = new HttpHeaders();
        headers.set(HttpHeaders.AUTHORIZATION, openDataAuth);

        try {
            String postJson = HttpUtil.postJson(openDataHost + "/api/performance/sales", JsonUtils.toJson(map), headers);
            log.info("response: {}", postJson);
            if (StringUtil.isBlank(postJson)) {
                return Collections.emptyList();
            }
            OpenDataSalesResponse openDataSalesResponse = JsonUtils.fromJson(postJson, OpenDataSalesResponse.class);
            if (!openDataSalesResponse.isSucc()) {
                return Collections.emptyList();
            }
            return openDataSalesResponse.getData();
        } catch (Exception e) {
            log.error("error", e);
        }
        return Collections.emptyList();
    }

    @Override
    public PerformanceTicketSalesDto getPerformanceTicketSalesInfo(String performanceId) {
        HttpHeaders headers = new HttpHeaders();
        headers.set(HttpHeaders.AUTHORIZATION, openDataAuth);

        try {
            String responseStr = HttpUtil.getByUri(openDataHost + "/api/performance/ticket/sales?performanceId=" + performanceId, headers);
            log.info("response: {}", responseStr);
            if (StringUtil.isBlank(responseStr)) {
                return null;
            }
            OpenDataTicketSalesResponse openDataSalesResponse = JsonUtils.fromJson(responseStr, OpenDataTicketSalesResponse.class);
            if (!openDataSalesResponse.isSucc()) {
                return null;
            }
            return openDataSalesResponse.getData();
        } catch (Exception e) {
            log.error("error", e);
        }
        return null;
    }
}
