package com.liquidnet.service.stone.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author liquidnet
 * @since 2021-10-19
 */
@Data
public class StoneUserVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 状态[1-正常|2-冻结]
     */
    private Integer status;

    /**
     * 每日任务：签到
     * 每日任务：购买演出
     * 每日任务：购买商品
     * 每日任务：划卡
     * 一次性任务：关注公众号
     * 一次性任务：完善信息
     * 一次性任务：完善头像
     * 一次性任务：打开消息推送
     * 一次性任务：体验在场
     */
    private List<StoneTaskVo> task;

    public List<StoneTaskVo> getTask() {
        if (task == null) {
            return initTask();
        }
        return task;
    }

    private List<StoneTaskVo> initTask() {
        task = new ArrayList();
        String[] taskName = new String[]{
                "签到", "购买演出票务", "购买商品", "在场划卡10次",
                "关注摩登天空服务号", "完善个人信息", "完善个人照片", "打开消息通知", "首次体验在场"
        };
        for (int i = 0; i < taskName.length; i++) {
            StoneTaskVo vo = StoneTaskVo.getNew();
            vo.setTaskName(taskName[i]);
            vo.setTaskId(i);
            if (i > 3) {
                vo.setTaskType(2);
            } else {
                vo.setTaskType(1);
            }
            vo.setTaskCount(0);
            vo.setTaskTime("2020-12-01");
            vo.setIsFinish(0);
            task.add(vo);
        }
        return task;
    }

    private static final StoneUserVo obj = new StoneUserVo();

    public static StoneUserVo getNew() {
        try {
            return (StoneUserVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new StoneUserVo();
        }
    }

}
