-- 积分活动表
drop TABLE if exists `sweet_integral_activity`;
CREATE TABLE `sweet_integral_activity`
(
    `mid`                   bigint unsigned NOT NULL AUTO_INCREMENT,
    `integral_activity_id`  varchar(255)    NOT NULL DEFAULT '' COMMENT '活动id',
    `activity_title`        varchar(255)    NOT NULL DEFAULT '' COMMENT '活动名称',
    `activity_img`          varchar(255)    NOT NULL DEFAULT '' COMMENT '活动图片',
    `activity_type`         tinyint         NOT NULL DEFAULT 0 COMMENT '活动类型 1转盘',
    `activity_num`          int             NOT NULL DEFAULT 0 COMMENT '活动玩一次所需积分',
    `estimated_num`         int             NOT NULL DEFAULT 0 COMMENT '预估玩此活动的总人数',
    `time_type`             tinyint         NOT NULL DEFAULT 0 COMMENT '活动时间类型 1长期 2开始结束时间',
    `start_time`            datetime        NULL     DEFAULT NULL COMMENT '如果活动有时间限制 开始时间',
    `end_time`              datetime        NULL     DEFAULT NULL COMMENT '如果活动有时间限制 结束时间',
    `express_fee_type`      tinyint         NOT NULL DEFAULT 0 COMMENT '快递费用类型 1包邮 2到付',
    `activity_rules`        text            NULL     DEFAULT NULL COMMENT '活动规则',
    `probability_publicity` text            NULL     DEFAULT NULL COMMENT '概率公示',
    `is_online`             tinyint         NOT NULL DEFAULT 0 COMMENT '是否上线 1未上线 2已上线',
    `created_at`            datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`            datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_integral_activity_id` (`integral_activity_id`),
    KEY `sweet_integral_activity_title` (`activity_title`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动表';

-- 积分活动奖品表
drop TABLE if exists `sweet_integral_activity_prize`;
CREATE TABLE `sweet_integral_activity_prize`
(
    `mid`                  bigint unsigned NOT NULL AUTO_INCREMENT,
    `prize_id`             varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品id',
    `integral_activity_id` varchar(255)    NOT NULL DEFAULT '' COMMENT '关联活动id',
    `prize_title`          varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品名称',
    `prize_describe`       varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品描述',
    `prize_img_init`       varchar(255)    NOT NULL DEFAULT '' COMMENT '初始展示奖品图片',
    `prize_img_select`     varchar(255)    NOT NULL DEFAULT '' COMMENT '中奖选中奖品图片',
    `prize_type`           tinyint         NOT NULL DEFAULT 0 COMMENT '奖品类型 1积分 2优惠券 3实物 4登登登VIP',
    `prize_type_num`       int             NOT NULL DEFAULT 0 COMMENT '单次奖励数量如积分 中奖给多少',
    `prize_num`            int             NOT NULL DEFAULT 0 COMMENT '奖品数量库存',
    `is_infinite`          tinyint         NOT NULL DEFAULT 1 COMMENT '是否是无限库存 1有限库存 2无限库存',
    `winning_probability`  decimal(10, 2)  NOT NULL DEFAULT 0 COMMENT '中奖概率',
    `created_at`           datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`           datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_prize_id` (`prize_id`),
    KEY `sweet_prize_integral_activity_id` (`integral_activity_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动奖品表';

-- 积分活动奖品里关联多奖品表
drop TABLE if exists `sweet_integral_activity_prize_relation`;
CREATE TABLE `sweet_integral_activity_prize_relation`
(
    `mid`               bigint unsigned NOT NULL AUTO_INCREMENT,
    `prize_relation_id` varchar(255)    NOT NULL DEFAULT '' COMMENT 'prize_relation_id',
    `prize_id`          varchar(255)    NOT NULL DEFAULT '' COMMENT 'prize_id',
    `coupon_id`         varchar(255)    NOT NULL DEFAULT '' COMMENT '券id',
    `coupon_title`      varchar(255)    NOT NULL DEFAULT '' COMMENT '券名称',
    `created_at`        datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`        datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_prize_relation_id` (`prize_relation_id`),
    KEY `sweet_prize_id` (`prize_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动奖品里关联多奖品表';

-- 积分活动抽奖记录表
drop TABLE if exists `sweet_integral_activity_draw`;
CREATE TABLE `sweet_integral_activity_draw`
(
    `mid`                    bigint unsigned NOT NULL AUTO_INCREMENT,
    `draw_id`                varchar(255)    NOT NULL DEFAULT '' COMMENT '抽奖id',
    `integral_activity_id`   varchar(255)    NOT NULL DEFAULT '' COMMENT '关联活动id',
    `activity_num`           int             NOT NULL DEFAULT 0 COMMENT '活动玩一次所需积分',
    `prize_id`               varchar(255)    NOT NULL DEFAULT '' COMMENT '关联奖品id',
    `prize_title`            varchar(255)    NOT NULL DEFAULT '' COMMENT '奖品名称',
    `prize_type`             tinyint         NOT NULL DEFAULT 0 COMMENT '奖品类型 1积分 2优惠券 3实物 4登登登VIP 5优先购买券',
    `prize_type_num`         int             NOT NULL DEFAULT 0 COMMENT '单次奖励数量如积分 中奖给多少',
    `relation_id`            varchar(255)    NOT NULL DEFAULT '' COMMENT '关联id 如商品id 券id',
    `user_id`                varchar(255)    NOT NULL DEFAULT '' COMMENT '关联用户id',
    `nickname`               varchar(255)    NOT NULL DEFAULT '' COMMENT '关联用户昵称',
    `receiving_addresses_id` varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货地址addresses_id',
    `receiving_name`         varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人姓名',
    `receiving_phone`        varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人手机号',
    `receiving_province`     varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人省份',
    `receiving_city`         varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人城市',
    `receiving_county`       varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人区县',
    `receiving_address`      varchar(255)    NOT NULL DEFAULT '' COMMENT 'adam收货人详细地址',
    `receiving_status`       smallint        NOT NULL DEFAULT 1 COMMENT '发放状态 1未发放 2已发放',
    `created_at`             datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`             datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_draw_id` (`draw_id`),
    KEY `sweet_draw_integral_activity_id` (`integral_activity_id`),
    KEY `sweet_draw_prize_id` (`prize_id`),
    KEY `sweet_draw_user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '积分活动抽奖记录表';