package com.liquidnet.service.kylin.dto.param.ticketSystem;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldListVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "STFieldListParam", description = "详情")
public class STFieldListParam implements Cloneable{
    @ApiModelProperty(value = "省ID [非必传]")
    long provinceId;
    @ApiModelProperty(value = "市ID [非必传]")
    long cityId;
    @ApiModelProperty(value = "区ID [非必传]")
    long districtId;
    @ApiModelProperty(value = "页码，默认1 [必传]")
    Integer pageNo;
    @ApiModelProperty(value = "每页条数最大200 [必传]")
    Integer pageSize;
    @ApiModelProperty(value = "场所名称，支持模糊查询 [非必传]")
    String venueName;

    private static final STFieldListParam obj = new STFieldListParam();

    public static STFieldListParam getNew() {
        try {
            return (STFieldListParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STFieldListParam();
    }
}
