package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.service.kylin.dao.PerformanceMemberAuditDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances/memberAudit")
public class KylinMemberAuditController extends BaseController {
    private String prefix = "zhengzai/kylin/performances/memberAudit";

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

    //@RequiresPermissions("kylin:performances:member")
    @GetMapping()
    public String memberAudit() {
        return prefix + "/memberAudit";
    }

    /**
     * 会员待审核列表
     */
    //@RequiresPermissions("kylin:performances:member")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(@RequestParam("title") String title, @RequestParam("pageNum") int page, @RequestParam("pageSize") int size) {
        startPage();
        List<PerformanceTitleDao> result = kylinPerformancesService.performanceMemberList(title, page, size).getList();
        return getDataTable(result);
    }

    //@RequiresPermissions("kylin:performances:member")
    @GetMapping("/edit/{performancesId}")
    public String edit(@PathVariable("performancesId") String performancesId, Integer status, ModelMap mmap) {
        PerformanceMemberAuditDao result = kylinPerformancesService.performanceMemberAuditInfo(performancesId, status);
        mmap.put("performanceMemberAuditDao", result);
        return prefix + "/edit";
    }

    //@RequiresPermissions("kylin:performances:member")
    @Log(title = "会员待审核", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    @ResponseBody
    public AjaxResult save(@RequestParam("performancesId") String performancesId, @RequestParam("status")Integer status, @RequestParam("rejectTxt")String rejectTxt) {
        boolean result = kylinPerformancesService.performanceMemberAudit(performancesId, status, rejectTxt);
        return toAjax(result);
    }

}
