/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.remoting;

import com.taobao.api.internal.toplink.BufferManager;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ChannelSender;
import com.taobao.api.internal.toplink.channel.ClientChannel;
import com.taobao.api.internal.toplink.channel.ClientChannelSelector;
import com.taobao.api.internal.toplink.remoting.FormatterException;
import com.taobao.api.internal.toplink.remoting.MethodCall;
import com.taobao.api.internal.toplink.remoting.MethodReturn;
import com.taobao.api.internal.toplink.remoting.RemotingClientChannelHandler;
import com.taobao.api.internal.toplink.remoting.RemotingException;
import com.taobao.api.internal.toplink.remoting.SynchronizedRemotingCallback;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicProxy
implements InvocationHandler {
    private int executionTimeout = 0;
    private URI remoteUri;
    private String uriString;
    private String serializationFormat;
    private ClientChannelSelector selector;
    private RemotingClientChannelHandler channelHandler;

    protected DynamicProxy(URI remoteUri, ClientChannelSelector selector, RemotingClientChannelHandler handler) {
        this.remoteUri = remoteUri;
        this.uriString = remoteUri != null ? remoteUri.toString() : "";
        this.selector = selector;
        this.channelHandler = handler;
    }

    public Object create(Class<?> interfaceClass, URI remoteUri) {
        this.uriString = remoteUri.toString();
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
    }

    public void setExecutionTimeout(int millisecond) {
        this.executionTimeout = millisecond;
    }

    public void setSerializationFormat(String format) {
        this.serializationFormat = format;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodCall methodCall = new MethodCall();
        methodCall.Uri = this.uriString;
        methodCall.MethodName = method.getName();
        methodCall.TypeName = method.getDeclaringClass().getName();
        methodCall.MethodSignature = method.getParameterTypes();
        methodCall.Args = args;
        MethodReturn methodReturn = this.invoke(methodCall, method.getReturnType());
        if (methodReturn.Exception == null) {
            return methodReturn.ReturnValue;
        }
        throw methodReturn.Exception;
    }

    public MethodReturn invoke(MethodCall methodCall) throws RemotingException, FormatterException {
        return this.invoke(methodCall, Object.class);
    }

    public MethodReturn invoke(MethodCall methodCall, Class<?> returnType) throws RemotingException, FormatterException {
        return this.invoke(methodCall, returnType, this.executionTimeout);
    }

    public MethodReturn invoke(MethodCall methodCall, int executionTimeoutMillisecond) throws RemotingException, FormatterException {
        return this.invoke(methodCall, Object.class, executionTimeoutMillisecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodReturn invoke(MethodCall methodCall, Class<?> returnType, int executionTimeoutMillisecond) throws RemotingException, FormatterException {
        SynchronizedRemotingCallback syncCallback = new SynchronizedRemotingCallback();
        syncCallback.returnType = returnType;
        syncCallback.serializationFormat = this.serializationFormat;
        HashMap<String, Object> transportHeaders = new HashMap<String, Object>();
        transportHeaders.put("RequestUri", this.uriString);
        ClientChannel channel = this.getChannel();
        try {
            MethodReturn methodReturn = this.send(channel, this.channelHandler.pending(syncCallback, (short)0, transportHeaders, methodCall), syncCallback, executionTimeoutMillisecond);
            return methodReturn;
        }
        finally {
            this.selector.returnChannel(channel);
        }
    }

    private ClientChannel getChannel() throws RemotingException {
        try {
            ClientChannel channel = this.selector.getChannel(this.remoteUri);
            channel.setChannelHandler(this.channelHandler);
            return channel;
        }
        catch (ChannelException e) {
            throw new RemotingException(Text.RPC_CAN_NOT_GET_CHANNEL, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodReturn send(ClientChannel clientChannel, final ByteBuffer buffer, SynchronizedRemotingCallback syncCallback, int executionTimeoutMillisecond) throws RemotingException {
        buffer.flip();
        try {
            clientChannel.send(buffer, new ChannelSender.SendHandler(){

                public void onSendComplete(boolean success) {
                    BufferManager.returnBuffer(buffer);
                }
            });
        }
        catch (ChannelException e) {
            throw this.unexcepException(syncCallback, Text.RPC_SEND_ERROR, e);
        }
        try {
            syncCallback.waitReturn(executionTimeoutMillisecond);
        }
        finally {
            this.channelHandler.cancel(syncCallback);
        }
        if (syncCallback.getFailure() != null) {
            throw this.unexcepException(syncCallback, Text.RPC_CALL_ERROR, syncCallback.getFailure());
        }
        return syncCallback.getMethodReturn();
    }

    private RemotingException unexcepException(SynchronizedRemotingCallback callback, String message, Throwable innerException) {
        if (innerException instanceof RemotingException) {
            return (RemotingException)innerException;
        }
        return innerException != null ? new RemotingException(message, innerException) : new RemotingException(message);
    }
}

