package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderVo", description = "订单详情展示")
@Data
public class AdamMemberOrderVo implements Serializable {
    private static final long serialVersionUID = 5258094625450569125L;

    @ApiModelProperty(position = 0, value = "订单号")
    private String orderNo;
    @ApiModelProperty(position = 1, value = "用户uid")
    private String uid;
    @ApiModelProperty(position = 2, value = "购买方式:0-购买会员 1-购买会员码,2-使用会员码")
    private Integer mode;
    @ApiModelProperty(position = 3, value = "会员id")
    private String memberId;
    @ApiModelProperty(position = 4, value = "会员名")
    private String memberName;
    @ApiModelProperty(position = 5, value = "会员价格id")
    private String memberPriceId;
    @ApiModelProperty(position = 6, value = "购买天数")
    private Integer days;
    @ApiModelProperty(position = 7, value = "订单状态:0未支付 1已支付 2已超时 5已退款")
    private Integer state;
    @ApiModelProperty(position = 8, value = "会员号")
    private String memberNo;
    @ApiModelProperty(position = 9, value = "支付类型")
    private String payChannel;
    @ApiModelProperty(position = 10, value = "支付单号")
    private String payNo;
    @ApiModelProperty(position = 11, value = "支付时间")
    private String paymentAt;
    @ApiModelProperty(position = 12, value = "生日")
    private String birthday;
    @ApiModelProperty(position = 13, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 14, value = "兑换码")
    private String memberCode;
    @ApiModelProperty(position = 15, value = "价格")
    private BigDecimal price;

    public static final AdamMemberOrderVo obj = new AdamMemberOrderVo();

    private static AdamMemberOrderVo getNew() {
        try {
            return (AdamMemberOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberOrderVo();
    }
}
