package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontHotWordService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontHotWord;
import com.liquidnet.service.goblin.mapper.GoblinFrontHotWordMapper;
import com.liquidnet.service.goblin.param.GoblinFrontHotWordBuildParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 热词
 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@Service
public class GoblinFrontHotWordServiceImpl extends ServiceImpl<GoblinFrontHotWordMapper, GoblinFrontHotWord> implements IGoblinFrontHotWordService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontHotWordMapper goblinFrontHotWordMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontHotWord goblinFrontHotWord){
        goblinFrontHotWord.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontHotWord.setHotWordId(IDGenerator.nextSnowId());
        //增加 banner
        goblinFrontHotWordMapper.insert(goblinFrontHotWord);
  /*      //mongo  db增加
        mongoTemplate.save(GoblinFrontHotWord,GoblinFrontHotWord.class.getSimpleName());
        //redis 增加
        LambdaQueryWrapper<GoblinFrontHotWord> queryWrapper = Wrappers.lambdaQuery(GoblinFrontHotWord.class);
        queryWrapper.ne(GoblinFrontHotWord::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontHotWord::getIndexs);
        List<GoblinFrontHotWord> list=goblinFrontBannerMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_HOTWORD,list);*/
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改
     * @date 2021/12/27 下午4:03
     */
    public boolean update(GoblinFrontHotWord goblinFrontHotWord){
        if(goblinFrontHotWord.getMid()==0){
            this.create(goblinFrontHotWord);
        }else{
            goblinFrontHotWord.setUpdateTime(LocalDateTime.now());
            //数据库修改
            goblinFrontHotWordMapper.updateById(goblinFrontHotWord);
        }


        /*//mongodb修改
        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontHotWord)));
        mongoTemplate.getCollection(GoblinFrontHotWord.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("hotWordId").is(goblinFrontHotWord.getHotWordId())).getQueryObject(),
                orderObject
        );
        //redis 修改
        //从数据库中查出来，从新塞进去
        LambdaQueryWrapper<GoblinFrontHotWord> queryWrapper = Wrappers.lambdaQuery(GoblinFrontHotWord.class);
        queryWrapper.ne(GoblinFrontHotWord::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontHotWord::getIndexs);
        List<GoblinFrontHotWord> list=goblinFrontHotWordMapper.selectList(queryWrapper);
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_HOTWORD,list);*/
        return  true;
    }
    /**
     * @author zhangfuxin
     * @Description:查看详情
     * @date 2021/12/27 下午4:34
     */
    public GoblinFrontHotWord getOne(Long id){
        return  goblinFrontHotWordMapper.selectById(id);
    }
    /**
     * @author zhangfuxin
     * @Description:  删除 banner
     * @date 2021/12/27 下午4:36
     */
    public boolean delete(Long id){
        GoblinFrontHotWord goblinFrontHotWord=goblinFrontHotWordMapper.selectById(id);
        goblinFrontHotWord.setDelTag(1);
        this.update(goblinFrontHotWord);
        return true;
    }
    public List<GoblinFrontHotWordBuildParam> listGoblinFrontHotWordBuildParam(){
        LambdaQueryWrapper<GoblinFrontHotWord> queryWrapper = Wrappers.lambdaQuery(GoblinFrontHotWord.class);
        queryWrapper.ne(GoblinFrontHotWord::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontHotWord::getCreateTime);
        List<GoblinFrontHotWord> list=goblinFrontHotWordMapper.selectList(queryWrapper);
        List<GoblinFrontHotWordBuildParam> list1=new ArrayList<>();
        for(GoblinFrontHotWord goblinFrontHotWord:list){
            GoblinFrontHotWordBuildParam goblinFrontHotWordBuildParam=new GoblinFrontHotWordBuildParam();
            BeanUtils.copyProperties(goblinFrontHotWord,goblinFrontHotWordBuildParam);
            list1.add(goblinFrontHotWordBuildParam);
        }
        return list1;
    }
    /**
     * @author zhangfuxin
     * @Description:分页
     * @date 2021/12/27 下午5:19
     */
    public PageInfo<GoblinFrontHotWord> page(int pageSize, int pageNumber, GoblinFrontHotWord goblinFrontHotWord) {
        PageInfo<GoblinFrontHotWord> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontHotWord> queryWrapper = Wrappers.lambdaQuery(GoblinFrontHotWord.class);
            queryWrapper.ne(GoblinFrontHotWord::getDelTag,1);
            queryWrapper.orderByDesc(GoblinFrontHotWord::getCreateTime);
            List<GoblinFrontHotWord> list=goblinFrontHotWordMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }
    public boolean online(){
        LambdaQueryWrapper<GoblinFrontHotWord> queryWrapper = Wrappers.lambdaQuery(GoblinFrontHotWord.class);
        queryWrapper.ne(GoblinFrontHotWord::getDelTag,1);
        queryWrapper.orderByDesc(GoblinFrontHotWord::getIndexs);
        List<GoblinFrontHotWord> list=goblinFrontHotWordMapper.selectList(queryWrapper);
        for(GoblinFrontHotWord goblinFrontHotWord: list){
            //查看 mongodb 有没有
            GoblinFrontHotWord goblinFrontHotWord1=mongoTemplate.findOne(Query.query(Criteria.where("hotWordId").is(goblinFrontHotWord.getHotWordId())), GoblinFrontHotWord.class, GoblinFrontHotWord.class.getSimpleName());
            if(null==goblinFrontHotWord1){
                mongoTemplate.save(goblinFrontHotWord,GoblinFrontHotWord.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontHotWord)));
                mongoTemplate.getCollection(GoblinFrontHotWord.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("hotWordId").is(goblinFrontHotWord.getHotWordId())).getQueryObject(),
                        orderObject
                );
            }

        }
        redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_HOTWORD,list);
        return true;
    }


}
