package com.liquidnet.service.sweet.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;

import java.io.Serializable;

/**
 * <p>
 * WxOAuth2UserInfo vo
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-28
 */

@Data
@ApiModel
public class WechatUserInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 5067978046376025813L;

    @ApiModelProperty(value = "普通用户的标识，对当前开发者帐号唯一")
    private String openid;

    @ApiModelProperty(value = "普通用户昵称")
    private String nickname;

    @ApiModelProperty(value = "普通用户性别，1为男性，2为女性")
    private Integer sex;

    @ApiModelProperty(value = "普通用户个人资料填写的城市")
    private String city;

    @ApiModelProperty(value = "普通用户个人资料填写的省份")
    private String province;

    @ApiModelProperty(value = "国家，如中国为CN")
    private String country;

    @ApiModelProperty(value = "用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像） 用户没有头像时该项为空")
    private String headImgUrl;

    @ApiModelProperty(value = "用户统一标识。针对一个微信开放平台帐号下的应用，同一用户的unionid是唯一的")
    private String unionId;

    @ApiModelProperty(value = "用户特权信息，json数组，如微信沃卡用户为（chinaunicom）")
    private String[] privileges;

    private static final WechatUserInfoVo obj = new WechatUserInfoVo();

    public static WechatUserInfoVo getNew() {
        try {
            return (WechatUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new WechatUserInfoVo();
        }
    }

    public WechatUserInfoVo copy(WxOAuth2UserInfo source) {
        if (null == source) return this;
        this.setOpenid(source.getOpenid());
        this.setNickname(source.getNickname());
        this.setSex(source.getSex());
        this.setCity(source.getCity());
        this.setProvince(source.getProvince());
        this.setCountry(source.getCountry());
        this.setHeadImgUrl(source.getHeadImgUrl());
        this.setUnionId(source.getUnionId());
        this.setPrivileges(source.getPrivileges());
        return this;
    }

}
