package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamEntersParam;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.service.IAdamEntersService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

/**
 * <p>
 * 入场人 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Api(tags = "入场人")
@Slf4j
@RestController
@RequestMapping("/enters")
public class AdamEntersController {
    @Autowired
    IAdamEntersService adamEntersService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加入场人")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamEntersParam parameter) {
        // TODO: 2021/4/28 数据校验，身份认证


        AdamEnters addInfo = new AdamEnters();
        BeanUtils.copyProperties(parameter, addInfo);
        addInfo.setCreatedAt(LocalDateTime.now());
        addInfo.setState(1);


        return adamEntersService.add(addInfo) ? ResponseDto.success() : ResponseDto.failure();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "入场人详情")
    @PostMapping("query/{id}")
    public ResponseDto<Object> query(@PathVariable int id) {
        // TODO: 2021/4/28 校验

        return ResponseDto.success(adamEntersService.query(id));
    }
}
