package com.liquidnet.service.kylin.model;

import com.liquidnet.service.kylin.entity.FieldRelations;
import com.liquidnet.service.kylin.entity.FieldStatus;
import com.liquidnet.service.kylin.entity.Fields;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
public class FieldsModule implements Serializable {
    @ApiModelProperty(value = "自增id")
    private int id;

    @ApiModelProperty(value = "主键id")
    private String fields_id;

    @ApiModelProperty(value = "场地名称")
    private String name;

    @ApiModelProperty(value = "英文名")
    private String name_eng;

    @ApiModelProperty(value = "拼音")
    private String pinyin;

    @ApiModelProperty(value = "封面图")
    private String cover_img;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "省id")
    private int province_id;

    @ApiModelProperty(value = "省名称")
    private String province_name;

    @ApiModelProperty(value = "城市id")
    private int city_id;

    @ApiModelProperty(value = "城市名称")
    private String city_name;

    @ApiModelProperty(value = "县id")
    private int district_id;

    @ApiModelProperty(value = "县名称")
    private String district_name;

    @ApiModelProperty(value = "拒绝理由")
    private String refuse_message;

    @ApiModelProperty(value = "认证状态 0未认证 1已认证")
    private int valid_status;

    @ApiModelProperty(value = "是否显示 0不显示 1显示")
    private int is_display;

    @ApiModelProperty(value = "是否营业 0不营业 1营业中")
    private int is_business;

    @ApiModelProperty(value = "审核状态 0待审核 1已审核 2被拒绝")
    private int change_status;

    @ApiModelProperty(value = "补充字段")
    private String comment;

    @ApiModelProperty(value = "创建时间")
    private String created_at;

    @ApiModelProperty(value = "修改时间")
    private String updated_at;

    public Fields getFields(){
        return new Fields();
    }

    public FieldStatus getFieldStatus(){
        return new FieldStatus();
    }

    public FieldRelations getFieldRelations(){
        return new FieldRelations();
    }
}
